(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     31884,        817]*)
(*NotebookOutlinePosition[     33337,        859]*)
(*  CellTagsIndexPosition[     33293,        855]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Periodizaci\[OAcute]n de funciones. Coeficientes de Fourier", "Title"],

Cell[TextData[StyleBox["Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez\n\
Departamento de An\[AAcute]lisis Matem\[AAcute]tico\nUniversidad de Granada",
  FontSize->12]], "Author",
  TextAlignment->Right],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section"],

Cell[BoxData[{
    \(\(Unprotect[Plot];\)\), "\[IndentingNewLine]", 
    \(Plot[f_, {x_, lims__ /; Length[{lims}] > 2}, 
        opts___] := \[IndentingNewLine]Block[{intervalos, discont, graf, 
          lineas, us}, \[IndentingNewLine]intervalos = \
\[IndentingNewLine]\(({#[\([1]\)] + \ 10. \^\(-15\), #[\([2]\)] - \ 
                    10. \^\(-15\)} &)\) /@ 
            Partition[{lims}, 2, 
              1]; \[IndentingNewLine]graf = \((Plot[f, 
                  Evaluate[
                    Prepend[#, 
                      x]], \[IndentingNewLine]DisplayFunction \[Rule] 
                    Identity, opts] &)\) /@ 
            intervalos; \[IndentingNewLine]discont = \((Drop[
                  Drop[{lims}, 1], \(-1\)] /. 
                us_?NumberQ \[Rule] {us - 10. \^\(-15\), 
                    us + 10. \^\(-15\)})\) // 
            Flatten; \[IndentingNewLine]discont = 
          discont /. 
            us_?NumberQ \[Rule] \ {us, 
                f /. x \[Rule] us}; \[IndentingNewLine]lineas = 
          Line /@ Partition[discont, 2]; \[IndentingNewLine]Show[{graf, 
            Graphics[{Dashing[{ .01,  .01}], 
                lineas}]}, \[IndentingNewLine]DisplayFunction \[Rule] \
$DisplayFunction]]\), "\[IndentingNewLine]", 
    \(\(Protect[Plot];\)\)}], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Periodizaci\[OAcute]n de funciones", "Section"],

Cell[TextData[{
  "Recuerda que una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f : \[DoubleStruckCapitalR] \[Rule] \
\[DoubleStruckCapitalR]\)]],
  " se llama peri\[OAcute]dica si hay un n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`T \[NotEqual] \ 0\)]],
  "tal que ",
  Cell[BoxData[
      \(TraditionalForm\`f(x + T) = f(x)\)]],
  " para todo ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] \[DoubleStruckCapitalR]\)]],
  " en cuyo caso se dice que ",
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  " es un periodo de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". Si ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " es peri\[OAcute]dica con periodo ",
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  " se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`f(x + n\ T) = f(x)\)]],
  " para todo entero ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " por lo que ",
  Cell[BoxData[
      \(TraditionalForm\`n\ T\)]],
  " tambi\[EAcute]n es un periodo de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". Las funciones constantes son funciones peri\[OAcute]dicas que admiten \
como periodo cualquier n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`T \[NotEqual] 0\)]],
  ". Salvo este caso, si ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " es una funci\[OAcute]n peri\[OAcute]dica no constante y que al menos es \
continua en un punto (condici\[OAcute]n que cumple cualquier funci\[OAcute]n \
\"interesante\") se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " tiene un periodo positivo m\[IAcute]nimo. Es a este periodo al que \
solemos referirnos cuando usamos la expresi\[OAcute]n \"",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " es una funci\[OAcute]n peri\[OAcute]dica con periodo ",
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  "\". As\[IAcute], por ejemplo, decimos que la funci\[OAcute]n seno es peri\
\[OAcute]dica con periodo 2\[Pi] y la funci\[OAcute]n tangente es peri\
\[OAcute]dica con periodo \[Pi]. Precisamente, el ejemplo de la \
funci\[OAcute]n tangente nos indica que no es preciso exigir que una funci\
\[OAcute]n peri\[OAcute]dica est\[EAcute] definida en todo \
\[DoubleStruckCapitalR], es suficiente que est\[EAcute] definida en un \
conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\)]],
  ", por lo general una uni\[OAcute]n de intervalos, tal que si ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] A\)]],
  " tambi\[EAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`x + T \[Element] A\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Para representar una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " por una serie de Fourier debemos elegir un intervalo acotado ",
  Cell[BoxData[
      \(TraditionalForm\`I\)]],
  " en el que queremos que la serie represente a la funci\[OAcute]n y debemos \
considerar que fuera de dicho intervalo la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " repite peri\[OAcute]dicamente los valores que toma en el mismo; esto es, \
consideramos a ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " como una funci\[OAcute]n peri\[OAcute]dica con periodo igual a la \
longitud del intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`I\)]],
  ". Esto es lo que se llamamaos \"periodizar a ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`I\)]],
  "\". Naturalmente, si la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " ya es por s\[IAcute] misma peri\[OAcute]dica con periodo ",
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  " lo l\[OAcute]gico es elegir como intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`I\)]],
  " el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-T\)/2, T/2]\)\)]],
  " o el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([0, T]\)\)]],
  " pues de esta forma la serie de Fourier obtenida representar\[AAcute] a la \
funci\[OAcute]n en todo \[DoubleStruckCapitalR].\nNo olvides que puedes \
cambiar los valores de una funci\[OAcute]n en un conjunto finito de puntos \
sin que ello afecte para nada a sus coeficientes de Fourier. Igualmente, si \
una funci\[OAcute]n est\[AAcute] definida en un intervalo excepto en un n\
\[UAcute]nero finito de puntos del mismo puedes definir como quieras dicha \
funci\[OAcute]n en esos puntos sin que ello afecte para nada a sus \
coeficientes de Fourier. La \[UAcute]nica condici\[OAcute]n que se precisa \
para calcular los coeficientes de Fourier de una funci\[OAcute]n en un \
intervalo es que la funci\[OAcute]n sea integrable en dicho intervalo y esa \
condici\[OAcute]n no se ve alterada si modificas la funci\[OAcute]n en un \
conjunto finito de puntos. \nSi periodizas una funci\[OAcute]n en un \
intervalo y la funci\[OAcute]n tiene valores diferentes en los extremos del \
mismo, aparecen discontinuidades de salto las cuales, al hacer la \
representaci\[OAcute]n gr\[AAcute]fica, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " une por un segmento vertical. En la inicializaci\[OAcute]n de este \
cuaderno he modificado el comando Plot[ ] para que una por una l\[IAcute]nea \
discontinua las discontinuidades de salto de una funci\[OAcute]n pero tienes \
que decirle t\[UAcute] a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " d\[OAcute]nde est\[AAcute]n dichas discontinuidades. La sintaxis del \
comando es \"Plot[funcion[x],{x,a,d1,d2,d3,...,b},opciones]\" y representa la \
gr\[AAcute]fica de \"funcion[x]\" en el intervalo [a,b] con discontinuidades \
de salto en los puntos d1,d2,d3,... . El nuevo comando solamente modifica a \
Plot[ ] cuando la lista {a,d1,d2,d3,...,b} tiene longitud mayor que 2, es \
decir, el comando Plot[ ] sigue funcionando igual que siempre si no pones \
ning\[UAcute]n punto de discontinuidad. Aqu\[IAcute] tienes un ejemplo (debes \
haber ejecutado ya la celda de inicializaci\[OAcute]n)."
}], "Text"],

Cell[BoxData[{
    \(\(f[
          x_] = \((x - 3)\)/Abs[x - 3] + \((x - 4)\)/Abs[x - 4] + \((x - 7)\)/
            Abs[x - 7];\) (*\ 
      discontinuidades\ de\ salto\ en\ los\ puntos\ 3, 4, 
      7\ *) \), "\[IndentingNewLine]", 
    \(\(Plot[f[x], {x, 0, 3, 4, 7, 9}, AspectRatio \[Rule] Automatic, 
        Ticks \[Rule] {{3, 4, 7}, Automatic}, 
        PlotStyle \[Rule] {Hue[ .65], Thickness[ .007]}];\)\)}], "Input"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "Define un comando de la forma \"periodiza[func_,a_,b_][x_]\" que \
proporcione la periodizaci\[OAcute]n de la funci\[OAcute]n \"func\" en el \
intervalo [a,b]. Es decir, \"periodiza[func,a,b][x]\" debe ser una funci\
\[OAcute]n peri\[OAcute]dica de periodo b-a y que coincide con f en [a,b].\n\
Sugerencias. La funci\[OAcute]n \"Mod[x,1]\" (consulta la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ") puede ser \[UAcute]til. Observa su gr\[AAcute]fica."
}], "ExerciseText"],

Cell[BoxData[
    \(\(Plot[Mod[x, 1], {x, \(-3\), \(-2\), \(-1\), 0, 1, 2, 3}, 
        AspectRatio \[Rule] Automatic, Ticks \[Rule] {Range[\(-3\), 3], {1}}, 
        PlotStyle \[Rule] {Hue[0], Thickness[ .005]}, 
        ImageSize \[Rule] {435.25, 72.5}];\)\)], "Input"],

Cell[TextData[{
  "Es claro que si ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " es una funci\[OAcute]n, entonces ",
  Cell[BoxData[
      \(TraditionalForm\`f[Mod[x, 1]]\)]],
  " es la periodizaci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\([0, 1]\)\)]],
  ". Aqu\[IAcute] puedes ver un ejemplo."
}], "ExerciseText"],

Cell[BoxData[
    \(\(Plot[{Sin[\[Pi]\ x], Sin[\[Pi]\ Mod[x, 1]]}, {x, \(-3\), 3}, 
        PlotStyle \[Rule] {Hue[0], {Thickness[ .007], Hue[ .65]}}, 
        AspectRatio \[Rule] Automatic];\)\)], "Input"],

Cell[TextData[{
  "Una \[UAcute]ltima observaci\[OAcute]n. La definici\[OAcute]n del comando \
que me parece m\[AAcute]s sencilla es de la forma \
periodiza[func_,a_,b_][x_]:=func[\"expresi\[OAcute]n que contiene a x\"]. Por \
ello para que el comando funcione al aplicarlo deber\[AAcute]s sustituir \
\"func\" por el nombre de la funci\[OAcute]n \"f\" o \"g\" o como se llame la \
funci\[OAcute]n, pero no por f[x] o g[x].\nAplica el comando que has definido \
para representar gr\[AAcute]ficamente la periodizaci\[OAcute]n en el \
intervalo que se indica de las siguientes funciones. En cada caso representa \
la funci\[OAcute]n y su periodizaci\[OAcute]n en la misma gr\[AAcute]fica y \
elige las opciones de color y grosor de l\[IAcute]nea que creas apropiadas. \
Haz la representaci\[OAcute]n en un intervalo suficientemente grande que \
contenga al menos tres periodos. Si la periodizaci\[OAcute]n tiene \
discontinuidades de salto repres\[EAcute]ntala a ella sola usando la \
modificaci\[OAcute]n del comando Plot[ ].\na) La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = x\ sen\ x\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-\[Pi]\), \[Pi]]\)\)]],
  ".\nb) La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(x\)\(|\)\)\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-1\), 1]\)\)]],
  ".\nc) La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = x\^3\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([1, 2]\)\)]],
  ".\nd) La funci\[OAcute]n \"escal\[OAcute]n unidad\" ",
  Cell[BoxData[
      \(TraditionalForm\`H(x) = 0\)]],
  " si ",
  Cell[BoxData[
      \(TraditionalForm\`x < 0\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`H(x) = 1\)]],
  " si ",
  Cell[BoxData[
      \(TraditionalForm\`x \[GreaterEqual] 0\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-1\)/2, 1/2]\)\)]],
  ".\ne) La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = x\ \(H(x)\)\)]],
  " en los intervalos",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\([0, 1]\)\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-1\)/2, 1/2]\)\)]],
  ".\nf) La funci\[OAcute]n \"impulso rectangular\" ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPi](x) = 1\)]],
  "si ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(x\)\(|\)\(\(<\)\(1/2\)\)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPi](x) = 0\)]],
  " si ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(x\)\(|\)\(\(\[GreaterEqual]\)\(1/
            2\)\)\)\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-2.5\), 2.5]\)\)]],
  "."
}], "ExerciseText"],

Cell[BoxData[
    \(\(periodiza[func_, a_, b_]\)[x_] := 
      func[a + \((b - a)\)*Mod[\((x - a)\)/\((b - a)\), 1]]\)], "Input"],

Cell[BoxData[
    \(\(\(periodiza[f_, a_, b_]\)[x_] := f[Mod[x, b - a, a]];\)\)], "Input"],

Cell[BoxData[
    StyleBox[\(Plot[{\(periodiza[#*Sin[#] &, \(-\[Pi]\), \[Pi]]\)[x], 
            x*Sin[x]}, {x, \(-3\) \[Pi], 3  \[Pi]}, 
          PlotStyle \[Rule] {{Thickness[0.007], Hue[0]}, Hue[0.65]}, 
          PlotRange \[Rule] All];\),
      FontFamily->"Courier New"]], "Input",
  FontFamily->"Trebuchet MS"],

Cell[BoxData[
    StyleBox[\(Plot[{\(periodiza[#^3 &, 1, 2]\)[x], x^3}, {x, \(-4\), 4}, 
          PlotStyle \[Rule] {{Thickness[0.007], Hue[0]}, Hue[0.65]}];\),
      FontFamily->"Courier New"]], "Input",
  FontFamily->"Trebuchet MS"],

Cell[BoxData[{
    StyleBox[\(H[x_] := If[x < 0, 0, 1]\),
      FontFamily->"Courier New"], "\[IndentingNewLine]", 
    StyleBox[\(Plot[{\(periodiza[H, \(-1\)/2, 1/2]\)[x], H[x]}, {x, \(-2.5\), 
            2.5}, PlotStyle \[Rule] {{Thickness[0.008], 
                Hue[0]}, {Thickness[0.004], Hue[ .65]}}, 
          AspectRatio \[Rule]  .4, Ticks \[Rule] {{\(-1\)\/2, 1\/2}, {1}}];\),
      
      FontFamily->"Courier New"]}], "Input",
  FontFamily->"Trebuchet MS"],

Cell[BoxData[
    StyleBox[\(Plot[\(periodiza[H, \(-1\)/2, 1/2]\)[
            x], {x, \(-2.5\), \(-2\), \(-1.5\), \(-1\), \(- .5\), 0,  .5, 1, 
            1.5, 2, 2.5}, PlotStyle \[Rule] {Thickness[0.008], Hue[0]}, 
          AspectRatio \[Rule]  .4, Ticks \[Rule] {{\(-1\)\/2, 1\/2}, {1}}];\),
      
      FontFamily->"Courier New"]], "Input",
  FontFamily->"Trebuchet MS"],

Cell[BoxData[
    StyleBox[\(Plot[{\(periodiza[#*H[#] &, \(-1\)/2, 1/2]\)[x], 
            x*H[x]}, {x, \(-2\), 2}, 
          PlotStyle \[Rule] {{Thickness[0.007], Hue[0]}, Hue[0.65]}];\),
      FontFamily->"Courier New"]], "Input",
  FontFamily->"Trebuchet MS"],

Cell[BoxData[
    StyleBox[\(Plot[\(periodiza[#*H[#] &, \(-1\)/2, 1/2]\)[
            x], {x, \(-2\), \(-1.5\), \(- .5\),  .5, 1.5, 2}, 
          PlotStyle \[Rule] {Thickness[0.007], Hue[0]}];\),
      FontFamily->"Courier New"]], "Input",
  FontFamily->"Trebuchet MS"],

Cell[BoxData[
    StyleBox[\(Plot[{\(periodiza[#*H[#] &, 0, 1]\)[x], x*H[x]}, {x, \(-2\), 
            2}, PlotStyle \[Rule] {{Thickness[0.007], Hue[0]}, Hue[0.65]}, 
          AspectRatio -> Automatic];\),
      FontFamily->"Courier New"]], "Input",
  FontFamily->"Trebuchet MS"],

Cell[BoxData[
    StyleBox[\(Plot[\(periodiza[#*H[#] &, 0, 1]\)[x], {x, \(-2\), \(-1\), 0, 
            1, 2}, PlotStyle \[Rule] {Thickness[0.007], Hue[0]}, 
          AspectRatio -> Automatic, Ticks -> {Automatic, { .5, 1}}];\),
      FontFamily->"Courier New"]], "Input",
  FontFamily->"Trebuchet MS"],

Cell[BoxData[{
    \(\(pulso[x_] = H[x +  .5] - H[x -  .5];\)\), "\[IndentingNewLine]", 
    \(\(Plot[{\(periodiza[pulso, \(-2.5\), 2.5]\)[x], pulso[x]}, {x, \(-8\), 
          8}, PlotStyle \[Rule] {{Thickness[0.007], 
              Hue[0]}, {Thickness[0.007], Hue[ .65]}}, 
        AspectRatio \[Rule]  .4, 
        Ticks \[Rule] {{\(-1\)\/2, 1\/2}, {1}}];\)\)}], "Input"],

Cell[BoxData[
    \(\(Plot[\(periodiza[pulso, \(-2.5\), 2.5]\)[
          x], {x, \(-8\), \(-5.5\), \(-4.5\), \(- .5\),  .5, 4.5, 5.5, 8}, 
        PlotStyle \[Rule] {Thickness[0.007], Hue[0]}, 
        AspectRatio \[Rule]  .4, 
        Ticks \[Rule] {{\(-1\)\/2, 1\/2}, {1}}];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell["\<\
Define un comando de la forma \"periodizapar[func_,a_][x_]\" que proporcione \
la periodizaci\[OAcute]n par de la funci\[OAcute]n \"func\" en el intervalo \
[-a/2,a/2]. Es decir, \"periodizapar[func,a][x]\" debe ser una \
funci\[OAcute]n par peri\[OAcute]dica de periodo a y que coincide con f en \
[0,a/2].
Sugerencias. Basta con modificar el comando antes definido. El ejercicio 1 b) \
te dar\[AAcute] la pista a seguir.\
\>", "ExerciseText"],

Cell[TextData[{
  "Aplica el comando que has definido para representar gr\[AAcute]ficamente \
la periodizaci\[OAcute]n par en el intervalo que se indica de las siguientes \
funciones. En cada caso representa la funci\[OAcute]n y su periodizaci\
\[OAcute]n en la misma gr\[AAcute]fica y elige las opciones de color y grosor \
de l\[IAcute]nea que creas apropiadas. \na) La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = \ sen(x\^3)\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-\[Pi]\)/2, \[Pi]/2]\)\)]],
  ".\nb) La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = \[ExponentialE]\^x\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-1\), 1]\)\)]],
  ".\nc) La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = 2  x\^2 - x\^3\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-2\), 2]\)\)]],
  "."
}], "ExerciseText"],

Cell[BoxData[
    \(\(periodizapar[f_, a_]\)[
        x_] := \(periodiza[f[Abs[#]] &, \(-a\)/2, a/2]\)[x]\)], "Input"],

Cell[BoxData[
    \(\(\(periodizapar[f_, a_]\)[x_] := 
        f[Abs[Mod[x, \(-a\), a/2]]];\)\)], "Input"],

Cell[BoxData[
    StyleBox[\(\(\(peripar[func_, a_]\)[x_]\)\(:=\)\(func[
          a*Mod[Abs[x/a - Round[x/a]], 1]]\)\(\ \)\( (*\ 
          esta\ es\ una\ definici\[OAcute]n\ directa\ que\ no\ usa\ el\ \
comando\ anterior\ *) \)\),
      FontFamily->"Courier New"]], "Input",
  FontFamily->"Trebuchet MS"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["Plot",
          FontFamily->"Courier New"], 
        StyleBox["[",
          FontFamily->"Courier New"], 
        RowBox[{
          RowBox[{
            StyleBox["{",
              FontFamily->"Courier New"], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["periodizapar",
                    FontFamily->"Courier New"], 
                  StyleBox["[",
                    FontFamily->"Courier New"], 
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        StyleBox["Sin",
                          FontFamily->"Courier New"], 
                        StyleBox["[",
                          FontFamily->"Courier New"], 
                        SuperscriptBox[
                          StyleBox["#",
                            FontFamily->"Courier New"], "3"], "]"}], "&"}], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox["\[Pi]",
                      FontFamily->"Courier New"]}], 
                  StyleBox["]",
                    FontFamily->"Courier New"]}], 
                StyleBox["[",
                  FontFamily->"Courier New"], 
                StyleBox["x",
                  FontFamily->"Courier New"], 
                StyleBox["]",
                  FontFamily->"Courier New"]}], 
              StyleBox[",",
                FontFamily->"Courier New"], 
              RowBox[{
                StyleBox["Sin",
                  FontFamily->"Courier New"], 
                StyleBox["[",
                  FontFamily->"Courier New"], 
                SuperscriptBox[
                  StyleBox["x",
                    FontFamily->"Courier New"], "3"], 
                StyleBox["]",
                  FontFamily->"Courier New"]}]}], 
            StyleBox["}",
              FontFamily->"Courier New"]}], 
          StyleBox[",",
            FontFamily->"Courier New"], 
          StyleBox[\({x, \(-\[Pi]\), \[Pi]}\),
            FontFamily->"Courier New"], 
          StyleBox[",",
            FontFamily->"Courier New"], 
          StyleBox[\(AspectRatio \[Rule]  .5\),
            FontFamily->"Courier New"], 
          StyleBox[",",
            FontFamily->"Courier New"], 
          
          StyleBox[\(PlotStyle \[Rule] {{Thickness[ .007], Hue[0]}, 
                Hue[ .65]}\),
            FontFamily->"Courier New"]}], 
        StyleBox["]",
          FontFamily->"Courier New"]}], 
      StyleBox[";",
        FontFamily->"Courier New"]}]], "Input",
  FontFamily->"Trebuchet MS"],

Cell[BoxData[
    \(\(Plot[{\(periodizapar[Exp, 2]\)[x], Exp[x]}, {x, \(-4\), 4}, 
        AspectRatio \[Rule] 1, 
        PlotRange \[Rule] {{\(-4\), 4}, {\(- .1\), 4}}, 
        AxesOrigin \[Rule] {0, 0}, 
        PlotStyle \[Rule] {{Thickness[ .007], Hue[0]}, 
            Hue[ .65]}];\)\)], "Input"],

Cell[BoxData[
    \(\(Plot[{\(periodizapar[\((2  #\^2 - #\^3)\) &, 4]\)[x], 
          2  x\^2 - x\^3}, {x, \(-4\), 4}, 
        PlotStyle \[Rule] {{Thickness[ .007], Hue[0]}, 
            Hue[ .65]}];\)\)], "Input",
  FontFamily->"Trebuchet MS"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell["\<\
Define un comando de la forma \"periodizaimpar[func_,a_][x_]\" que \
proporcione la periodizaci\[OAcute]n impar de la funci\[OAcute]n \"func\" en \
el intervalo [-a/2,a/2]. Es decir, \"periodizaimpar[func,a][x]\" debe ser una \
funci\[OAcute]n impar peri\[OAcute]dica de periodo a y que coincide con f en \
[0,a/2].
Sugerencias. Basta con modificar el comando definido en el ejercicio anterior \
multiplic\[AAcute]ndolo por una funci\[OAcute]n apropiada. La funci\[OAcute]n \
Sign[ ] puede ser \[UAcute]til (consulta la ayuda del programa).\
\>", "ExerciseText"],

Cell[TextData[{
  "Aplica el comando que has definido para representar gr\[AAcute]ficamente \
la periodizaci\[OAcute]n impar en el intervalo que se indica de las \
siguientes funciones. En cada caso representa la funci\[OAcute]n y su \
periodizaci\[OAcute]n en la misma gr\[AAcute]fica y elige las opciones de \
color y grosor de l\[IAcute]nea que creas apropiadas. \na) La funci\[OAcute]n \
",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = \(cos(x)\) \(sen(x\^2)\)\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-\[Pi]\)/2, \[Pi]/2]\)\)]],
  ".\nb) La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = \[ExponentialE]\^x - 1\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-2\), 2]\)\)]],
  ".\nc) La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = 2  x\^2 - x\^3\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-2\), 2]\)\)]],
  "."
}], "ExerciseText"],

Cell[BoxData[
    \(\(periodizaimpar[func_, a_]\)[x_] := 
      Sign[Mod[\((x - a/2)\)/a, 1] -  .5]*\(periodizapar[func[#] &, a]\)[
          x]\)], "Input"],

Cell[BoxData[
    \(\(\(periodizaimpar[f_, a_]\)[x_] := 
        f[Abs[Mod[x, \(-a\), a/2]]]*Sign[Mod[x, \(-a\), a/2]];\)\)], "Input"],

Cell[BoxData[
    StyleBox[\(\(periodizaimpar[func_, a_]\)[
          x_] := \(\(Sign[x]\)\(*\)\(Sign[
            1/2 - Abs[x]/a\  + IntegerPart[Abs[x]/a]]\)\(*\)\(func[
            a*Mod[Abs[Abs[x]\/a - Round[Abs[x]\/a]], 1]]\)\(\ \)\( (*\ 
            una\ definici\[OAcute]n\ directa\ *) \)\)\),
      FontFamily->"Courier New"]], "Input",
  FontFamily->"Trebuchet MS"],

Cell[BoxData[
    StyleBox[\(Plot[{\(periodizaimpar[\((Exp[#] - 1)\) &, 4]\)[x], 
            Exp[x] - 1}, {x, \(-4\), 4}, 
          PlotStyle \[Rule] {{Thickness[ .007], Hue[0]}, Hue[ .65]}];\),
      FontFamily->"Courier New"]], "Input",
  FontFamily->"Trebuchet MS"],

Cell[BoxData[
    StyleBox[\(Plot[{\(periodizaimpar[Cos[#] Sin[#\^2] &, \[Pi]]\)[x], 
            Cos[x] Sin[x\^2]}, {x, \(-\[Pi]\), \[Pi]}, 
          PlotStyle \[Rule] {{Thickness[ .007], Hue[0]}, Hue[ .65]}];\),
      FontFamily->"Courier New"]], "Input",
  FontFamily->"Trebuchet MS"],

Cell[BoxData[
    StyleBox[\(Plot[{\(periodizaimpar[2  #\^2 - #\^3 &, 4]\)[x], 
            2  x\^2 - x\^3}, {x, \(-3\), 3}, 
          PlotStyle \[Rule] {{Thickness[ .007], Hue[0]}, Hue[ .65]}];\),
      FontFamily->"Courier New"]], "Input",
  FontFamily->"Trebuchet MS"],

Cell[BoxData[{
    \(sptamp[p_, q_, period_] := 
      Table[{k/period, 
          Abs[If[k \[GreaterEqual] 0, \((a[k] - \[ImaginaryI]\ b[k])\)/
                2. , \((a[\(-k\)] + \[ImaginaryI]\ b[\(-k\)])\)/2. ]]}, {k, 
          p, q, 1}]\[IndentingNewLine] (*\ 
      construye\ el\ espectro\ de\ amplitudes\ para\ p \[LessEqual] 
        k \[LessEqual] q\ *) \), "\[IndentingNewLine]", 
    \(sptfases[p_, q_, period_] := 
      Table[{k/period, 
          Which[N[a[k]] \[Equal] N[b[k]] \[Equal] 0, 0, k \[GreaterEqual] 0, 
            Arg[\((a[k] - \[ImaginaryI]\ b[k])\)/2. ], \ 
            k \[LessEqual] \(-1\), 
            Arg[\((a[\(-k\)] + \[ImaginaryI]\ b[\(-k\)])\)/2. ]]}, {k, p, q, 
          1}]\[IndentingNewLine] (*\ 
      construye\ el\ espectro\ de\ fases\ para\ p \[LessEqual] k \[LessEqual] 
        q\ *) \), "\[IndentingNewLine]", 
    \(SpectrumAmplitudesPlot[p_, q_, period_, opts___] := 
      Show[Graphics[{\((Line[{{#1[\([1]\)], 0}, #1}] &)\) /@ 
              sptamp[p, q, period], 
            Join[{Hue[0], PointSize[0.0165]}, \((Point[#1] &)\) /@ 
                sptamp[p, q, period]]}, opts]]\[IndentingNewLine] (*\ 
      representa\ el\ espectro\ de\ amplitudes\ para\  - p \[LessEqual] 
        k \[LessEqual] q\ *) \), "\[IndentingNewLine]", 
    \(SpectrumFasesPlot[p_, q_, period_, opts___] := 
      Show[Graphics[{\((Line[{{#1[\([1]\)], 0}, #1}] &)\) /@ 
              sptfases[p, q, period], 
            Join[{Hue[0], PointSize[0.0165]}, \((Point[#1] &)\) /@ 
                sptfases[p, q, period]]}, opts]]\), "\[IndentingNewLine]", 
    \( (*\ representa\ el\ espectro\ de\ fases\ para\ p \[LessEqual] 
        k \[LessEqual] q\ *) \)}], "Input"],

Cell[BoxData[{
    \(\(A[f_, n_, {c_, d_}] = 
        Integrate[
          2\/\(d - c\)\ Cos[\(2\ n\ \[Pi]\ t\)\/\(d - c\)]\ f[t], {t, c, d}, 
          Assumptions \[Rule] 
            n \[Element] \ Integers];\)\), "\[IndentingNewLine]", 
    \(\(B[f_, n_, {c_, d_}] = 
        Integrate[
          2\/\(d - c\)\ Sin[\(2\ n\ \[Pi]\ t\)\/\(d - c\)]\ f[t], {t, c, d}, 
          Assumptions \[Rule] n \[Element] \ Integers];\)\)}], "Input"],

Cell[BoxData[{
    \(\(f[t_] := t*Sin[\[Pi]\ t];\)\), "\[IndentingNewLine]", 
    \(a[n_] = A[f, n, {\(-1\), 1}]\), "\[IndentingNewLine]", 
    \(b[n_] = B[f, n, {\(-1\), 1}]\), "\[IndentingNewLine]", 
    \(Simplify[a[2  n - 1], n \[Element] Integers]\), "\n", 
    \(Simplify[a[2  n], n \[Element] Integers]\[IndentingNewLine] (*\ 
      a[0] = A[f, 0, {\(-1\), 1}]*) \), "\[IndentingNewLine]", 
    \( (*\ a[1] = A[f, 1, {\(-1\), 1}]*) \)}], "Input"],

Cell[BoxData[{
    \(NA[f_, n_, {a_, b_}] := \(NA[f, n, {a, b}] = 
        Chop[2\/\(b - a\)\ NIntegrate[
              Cos[\(2\ n\ \[Pi]\ t\)\/\(b - a\)]\ f[t], {t, a, b}, 
              AccuracyGoal -> 4]]\)\), "\n", 
    \(NB[f_, n_, {a_, b_}] := \(NB[f, n, {a, b}] = 
        Chop[2\/\(b - a\)\ NIntegrate[
              Sin[\(2\ n\ \[Pi]\ t\)\/\(b - a\)]\ f[t], {t, a, b}, 
              AccuracyGoal -> 4]]\)\)}], "Input",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(\(PoliFourier[f_, N_, {c_, d_}]\)[x_] := 
      Block[{a, b, list1, list2, k}, a[k_] = A[f, k, {c, d}]; 
        b[k_] = B[f, k, {c, d}]; 
        list1 = k /. Solve[Denominator[a[k]] \[Equal] 0, k]; 
        If[Length[list1] > 0, 
          Do[a[list1[\([j]\)]] = A[f, list1[\([j]\)], {c, d}], {j, 1, 
              Length[list1]}]]; 
        list2 = k /. 
            Solve[Denominator[b[k]] \[Equal] 0, k]; \[IndentingNewLine]If[
          Length[list2] > 0, 
          Do[b[list2[\([j]\)]] = B[f, list2[\([j]\)], {c, d}], {j, 1, 
              Length[list1]}]]; \[IndentingNewLine]a[0]/2 + 
          Plus @@ Table[
              a[m]\ Cos[\(2\ m\ \[Pi]\ x\)\/\(c - d\)] + 
                b[m]\ Sin[\(2\ m\ \[Pi]\ x\)\/\(c - d\)], {m, 1, 
                N}]]\)], "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(\(PoliFourier[f, 10, {\(-1\), 1}]\)[t]\)], "Input"],

Cell[BoxData[
    \(\(PoliFourierLast[f_, N_, {c_, d_}]\)[x_] := 
      Block[{a, b}, a[k_] = A[f, k, {c, d}]; b[k_] = B[f, k, {c, d}]; 
        a[0] = A[f, 0, {c, d}]; a[1] = A[f, 1, {c, d}]; b[0] = 0; 
        b[1] = B[f, 1, {c, d}]; \[IndentingNewLine]a[0]/2 + 
          Plus @@ Table[
              a[m]\ Cos[\(2\ m\ \[Pi]\ x\)\/\(c - d\)] + 
                b[m]\ Sin[\(2\ m\ \[Pi]\ x\)\/\(c - d\)], {m, 1, 
                N}]]\)], "Input"],

Cell[BoxData[
    \(\(PoliFourierLast[f, 30, {\(-1\), 1}]\)[x]\)], "Input"],

Cell[BoxData[
    \(\(Table[\(poli[k]\)[t_] = \(PoliFourier[f, k, {\(-1\), 1}]\)[t], {k, 1, 
          10}];\)\)], "Input"],

Cell[BoxData[
    \(Do[Plot[{Evaluate[\(periodiza[f, \(-1\), 1]\)[t]], \(poli[k]\)[
            t]}, {t, \(-3\), 3}, PlotStyle \[Rule] {Hue[0], Hue[ .5]}, 
        PlotRange \[Rule] {\(- .1\),  .7}], {k, 5, 10}]\)], "Input"],

Cell[BoxData[{
    \(\(\(NewPoliFourier[f_, 1, {c_, d_}]\)[x_] = 
        A[f, 0, {c, d}]/2 + A[f, 1, {c, d}] Cos[\(2\ \[Pi]\ x\)\/\(c - d\)] + 
          B[f, 1, {c, d}] 
            Sin[\(2\ \[Pi]\ x\)\/\(c - d\)];\)\), "\[IndentingNewLine]", 
    \(\(\(NewPoliFourier[f_, n_, {c_, d_}]\)[
          x_] := \(\(NewPoliFourier[f, n, {c, d}]\)[
            x] = \(NewPoliFourier[f, n - 1, {c, d}]\)[x] + 
            A[f, n, {c, d}]\ Cos[\(2\ n\ \[Pi]\ x\)\/\(c - d\)] + 
            B[f, n, {c, 
                  d}]\ Sin[\(2\ n\ \[Pi]\ x\)\/\(c - d\)]\);\)\)}], "Input"],

Cell[BoxData[
    \(\(NewPoliFourier[f, 10, {\(-1\), 1}]\)[x]\)], "Input"],

Cell[BoxData[
    \(\(NPoliFourier[f_, N_, {a_, b_}]\)[x_] := 
      NA[f, 0, {a, b}]/2 + 
        Plus @@ Table[
            NA[f, m, {a, b}]\ Cos[\(2\ m\ \[Pi]\ x\)\/\(b - a\)] + 
              NB[f, m, {a, b}]\ Sin[\(2\ m\ \[Pi]\ x\)\/\(b - a\)], {m, 1, 
              N}]\)], "Input"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
WindowSize->{1016, 635},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "Periodizaci\[OAcute]n de funciones. Coeficientes de Fourier"], 
        "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "Periodizaci\[OAcute]n de funciones. Coeficientes de Fourier"], 
        "Header"]}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 76, 0, 174, "Title"],
Cell[1833, 53, 204, 3, 102, "Author"],

Cell[CellGroupData[{
Cell[2062, 60, 41, 0, 93, "Section"],
Cell[2106, 62, 1382, 28, 384, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[3525, 95, 53, 0, 93, "Section"],
Cell[3581, 97, 2616, 73, 249, "Text"],
Cell[6200, 172, 3412, 71, 533, "Text"],
Cell[9615, 245, 426, 8, 150, "Input"],

Cell[CellGroupData[{
Cell[10066, 257, 31, 0, 68, "Exercise"],
Cell[10100, 259, 513, 9, 127, "ExerciseText"],
Cell[10616, 270, 271, 4, 124, "Input"],
Cell[10890, 276, 399, 14, 67, "ExerciseText"],
Cell[11292, 292, 206, 3, 98, "Input"],
Cell[11501, 297, 2743, 73, 435, "ExerciseText"],
Cell[14247, 372, 129, 2, 72, "Input"],
Cell[14379, 376, 90, 1, 72, "Input"],
Cell[14472, 379, 318, 6, 98, "Input"],
Cell[14793, 387, 235, 4, 98, "Input"],
Cell[15031, 393, 470, 9, 186, "Input"],
Cell[15504, 404, 377, 7, 179, "Input"],
Cell[15884, 413, 263, 5, 98, "Input"],
Cell[16150, 420, 270, 5, 98, "Input"],
Cell[16423, 427, 280, 5, 124, "Input"],
Cell[16706, 434, 303, 5, 124, "Input"],
Cell[17012, 441, 374, 6, 180, "Input"],
Cell[17389, 449, 292, 5, 153, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17718, 459, 31, 0, 68, "Exercise"],
Cell[17752, 461, 454, 8, 127, "ExerciseText"],
Cell[18209, 471, 950, 24, 195, "ExerciseText"],
Cell[19162, 497, 118, 2, 72, "Input"],
Cell[19283, 501, 106, 2, 72, "Input"],
Cell[19392, 505, 306, 6, 98, "Input"],
Cell[19701, 513, 2646, 72, 108, "Input"],
Cell[22350, 587, 303, 6, 124, "Input"],
Cell[22656, 595, 246, 5, 108, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22939, 605, 31, 0, 68, "Exercise"],
Cell[22973, 607, 572, 9, 153, "ExerciseText"],
Cell[23548, 618, 971, 25, 195, "ExerciseText"],
Cell[24522, 645, 157, 3, 98, "Input"],
Cell[24682, 650, 134, 2, 72, "Input"],
Cell[24819, 654, 373, 7, 149, "Input"],
Cell[25195, 663, 270, 5, 98, "Input"],
Cell[25468, 670, 288, 5, 99, "Input"],
Cell[25759, 677, 272, 5, 99, "Input"],
Cell[26034, 684, 1700, 30, 514, "Input"],
Cell[27737, 716, 440, 9, 209, "Input"],
Cell[28180, 727, 453, 7, 228, "Input"],
Cell[28636, 736, 488, 10, 257, "Input"],
Cell[29127, 748, 830, 17, 284, "Input"],
Cell[29960, 767, 71, 1, 72, "Input"],
Cell[30034, 770, 447, 8, 180, "Input"],
Cell[30484, 780, 75, 1, 72, "Input"],
Cell[30562, 783, 123, 2, 72, "Input"],
Cell[30688, 787, 224, 3, 98, "Input"],
Cell[30915, 792, 573, 10, 285, "Input"],
Cell[31491, 804, 74, 1, 94, "Input"],
Cell[31568, 807, 288, 6, 181, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

